/*
 * Copyright (c) 2008-2016, RF-Embedded GmbH
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice,
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef CPPRFEREADERINTERFACE_H
#define CPPRFEREADERINTERFACE_H

#include "types.h"
#include "trace/ITraceInterface.h"

#include <string>

namespace CPPrfeReaderInterface
{

    /// <summary>
    /// Global class to hold the trace interface
    /// </summary>
    class Global
    {
    public:
        /// <summary>
        /// Instance of the used tracer. Change this to change the trace.
        /// </summary>
        static ITraceInterface* m_tracer;

        /// <summary>
        /// Sends the given trace message with the trace level to the used trace instance.
        /// </summary>
        /// <param name="level">Trace level of the message</param>
        /// <param name="text">Trace message</param>
        static void trc(int level, std::string text)
        {
            if(m_tracer != 0)
                m_tracer->trc(level, text);
        }
    };



    /// <summary>
    /// Helper class to be platform independant (Pair vs. Tuple)
    /// </summary>
    /// <typeparam name="T">Type 1</typeparam>
    /// <typeparam name="U">Type 2</typeparam>
    template < typename T, typename U >
    class Pair
    {

    public:
        /// <summary>
        /// Constructs an empty object
        /// </summary>
        Pair()
        {
        }

        /// <summary>
        /// Constructs a new object with the given data
        /// </summary>
        /// <param name="first">Data for first</param>
        /// <param name="second">Data for second</param>
        Pair(T first, U second)
        {
            this->First = first;
            this->Second = second;
        }

        /// <summary>
        /// Copy Constructor
        /// </summary>
        /// <param name="other">Other object</param>
        Pair(const Pair& other)
        {
            this->First = other.First;
            this->Second = other.Second;
        }
    public:
        /// <summary>
        /// The first data of the pair
        /// </summary>
        T First;

        /// <summary>
        /// The second data of the pair
        /// </summary>
        U Second;
    };
}

#endif // CPPRFEREADERINTERFACE_H
